//+------------------------------------------------------------------+
//|                                                    Recent SR.mq4 |
//+------------------------------------------------------------------+

#property indicator_chart_window

#define   MAX_QPS   9999

#include <hanover --- function header.mqh>

extern string    ParameterFile          = "NONE";
extern string    TimeFrame              = "";
extern int       LookbackCandles        = 50;
extern datetime  StartDateTime          = D'1971.01.01 00:00';
extern bool      IncludeCurrentCandle   = false;
extern double    BandwidthPips          = 1;
extern string    FrequencyLevels        = "1,2,3,4";
extern string    FrequencyColors        = "r85,r125,r155,r175";
extern color     ColorChart             = White;
extern bool      IncludeNextBandAbove   = false;
extern string    VisibilityLevel        = "1,1";
extern double    ClearancePips          = 0;
extern bool      VisCompletionRequired  = false;
extern bool      CandleHighsValid       = true;
extern bool      CandleLowsValid        = true;
extern bool      CandleClosesValid      = false;
extern bool      AllCandlePointsValid   = false;
//extern int       MinInterveningCandles  = 0;
//extern int       MaxInterveningCandles  = 9999;
extern int       LineWidth              = 0;
extern bool      Background             = true;
extern string    LineOrBandLength       = "0";
extern int       HistogramSize          = 0;
extern int       HistogramFontSize      = 8;
extern string    HistogramFont          = "Arial";
extern color     HistogramFontColor     = White;
extern string    HistogramPriceMask     = "";
extern bool      ShowHistogramOnly      = false;
extern string    ShowOnTimeFrames       = "M1,M5,M15,M30,H1,H4,D1,W1,MN";
extern string    DescriptionMask        = "'SR'B'-'";
extern double    PlotProximityPips      = -1;
extern int       HistoricalShift        = 0;
extern string    RefreshEveryXMins      = "M1";
extern string    OutputFile             = "";
extern int       OutputMinFrequency     = 0;
extern string    UniqueID               = "0";
extern bool      DeleteLinesOnDeinit    = true;

string   ccy, sym, IndiName, VL[2], mask, LOBL[3], LOBL2;
int      dig, tf, tmf, mult, c, ccCL, ccCC, CL[9], xCount[MAX_QPS], xStartBar[MAX_QPS], xLastBar[MAX_QPS], VL1, VL2, RefreshFreq, LOBL1, LOBL3;
double   spr, pnt, tickval, bidp, askp, HH, LL, O, H, L, C;
datetime prev_time, lastick;
string   outline[MAX_QPS];
color    CC[9];
bool     debugging = false;

//+------------------------------------------------------------------+
int init()  {
//+------------------------------------------------------------------+
  sym     = Symbol();
  ccy     = Symbol();
  tmf     = Period();
  bidp    = MarketInfo(ccy,MODE_BID);
  askp    = MarketInfo(ccy,MODE_ASK);
  pnt     = MarketInfo(ccy,MODE_POINT);
  dig     = MarketInfo(ccy,MODE_DIGITS);
  spr     = MarketInfo(ccy,MODE_SPREAD);
  tickval = MarketInfo(ccy,MODE_TICKVALUE);
  if (dig == 3 || dig == 5) {
    pnt     *= 10;
    spr     /= 10;
    tickval *= 10;
  }  
  if (dig > 3)   mult = 10000;   else   mult = 100;  

  prev_time = -9999;

  IndicatorDigits(dig);

  del_obj();
  plot_obj();    

  return(0);
}

//+------------------------------------------------------------------+
int deinit()  {
//+------------------------------------------------------------------+
  if (DeleteLinesOnDeinit)
    del_obj();
  return(0);
}

//+------------------------------------------------------------------+
int start()  {
//+------------------------------------------------------------------+
  if (RefreshFreq < 0)
    return(0);
  if (RefreshFreq == 0) {
    del_obj();
    plot_obj();    
  }
  else {
    if (prev_time != iTime(sym,RefreshFreq,0))  {
      del_obj();
      plot_obj();
      prev_time = iTime(sym,RefreshFreq,0);
  } }      
  return(0);
}

//+------------------------------------------------------------------+
void del_obj()  {
//+------------------------------------------------------------------+
  int k=0;
  while (k<ObjectsTotal())   {
    string objname = ObjectName(k);
    if (StringSubstr(objname,0,StringLen(IndiName)) == IndiName)  
      ObjectDelete(objname);
    else
      k++;
  }    
  return(0);
}

//+------------------------------------------------------------------+
void plot_obj()   {
//+------------------------------------------------------------------+

  CheckPresets();

  lastick = MarketInfo(ccy,MODE_TIME);
  bidp    = MarketInfo(ccy,MODE_BID);
  spr     = MarketInfo(ccy,MODE_SPREAD);
  pnt     = MarketInfo(ccy,MODE_POINT);
  tickval = MarketInfo(ccy,MODE_TICKVALUE);
  if (dig == 3 || dig == 5) {
    spr     /= 10;
    pnt     *= 10;
    tickval *= 10;
  }  

  if (dig > 3) {
    mult = 10000;   
    mask = "2." + NumberToStr(dig,"1");
  } else {
    mult = 100;  
    mask = "4." + NumberToStr(dig,"1");
  }  

  int DispTF = GetVisibility(ShowOnTimeFrames);

  if (LookbackCandles < 1)
    int FirstCandle = iBarShift(ccy,tf,StartDateTime,false);
  else 
    FirstCandle = LookbackCandles;
  FirstCandle = MathMin(FirstCandle, iBars(ccy,tf)-VL1-1);
  if (IncludeCurrentCandle)
    int LastCandle = 0;
  else
    LastCandle = 1;

  FirstCandle = FirstCandle + HistoricalShift;
  LastCandle  = LastCandle + HistoricalShift;

  double BasePrice = 999999;  
  for (int i=FirstCandle; i>=LastCandle; i--)
    BasePrice = MathMin(BasePrice,iLow(ccy,tf,i));

  BasePrice = BandwidthPips/mult * MathFloor(BasePrice*mult/BandwidthPips);

  ArrayInitialize(xCount,0);
  ArrayInitialize(xStartBar,-1);
  ArrayInitialize(xLastBar,-1);

  int h_elem = -1;  
  int h_freq = 0;  
  for (i=FirstCandle; i>=LastCandle; i--)   {
    if (AllCandlePointsValid)  {
      int elem1 = MathFloor((iLow(ccy,tf,i) - BasePrice) * mult/BandwidthPips);
      int elem2 = MathFloor((iHigh(ccy,tf,i) - BasePrice) * mult/BandwidthPips);
      for (int elem=elem1; elem<=elem2; elem++)   {
        xCount[elem] += 1;
        xLastBar[elem] = i;
        if(xStartBar[elem] < 0)   xStartBar[elem] = i;
        h_elem = MathMax(h_elem,elem);
        h_freq = MathMax(h_freq,xCount[elem]);
    } }   
    elem = MathFloor((iClose(ccy,tf,i) - BasePrice) * mult/BandwidthPips);
    if (CandleClosesValid && xLastBar[elem] != i)  {
      bool validH = true;
      bool validL = true;
      for (int j=VL1; j>=-VL2; j--)  {
        if (j==0)  continue;
        if (i+j < 0)  break;
        if (iClose(ccy,tf,i+j) > iClose(ccy,tf,i) - ClearancePips*pnt)   validH = false;
        if (iClose(ccy,tf,i+j) < iClose(ccy,tf,i) + ClearancePips*pnt)   validL = false;
      }
      if (VisCompletionRequired && i <= VL2)   { validH = false; validL = false; }
      if (validH || validL)  {
        xCount[elem] += 1;
        xLastBar[elem] = i;
        if(xStartBar[elem] < 0)   xStartBar[elem] = i;
        h_elem = MathMax(h_elem,elem);
        h_freq = MathMax(h_freq,xCount[elem]);
    } }   
    elem = MathFloor((iHigh(ccy,tf,i) - BasePrice) * mult/BandwidthPips);
    if (CandleHighsValid && xLastBar[elem] != i)  {
      validH = true;
      for (j=VL1; j>=-VL2; j--)  {
        if (j==0)  continue;
        if (i+j < 0)  break;
        if (iHigh(ccy,tf,i+j) > iHigh(ccy,tf,i) - ClearancePips*pnt)   validH = false;
      }
      if (VisCompletionRequired && i <= VL2)   validH = false;
      if (validH)  {
        xCount[elem] += 1;
        xLastBar[elem] = i;
        if(xStartBar[elem] < 0)   xStartBar[elem] = i;
        h_elem = MathMax(h_elem,elem);
        h_freq = MathMax(h_freq,xCount[elem]);
    } }
    elem = MathFloor((iLow(ccy,tf,i) - BasePrice) * mult/BandwidthPips);
    if (CandleLowsValid && xLastBar[elem] != i)  {
      validL = true;
      for (j=VL1; j>=-VL2; j--)  {
        if (j==0)  continue;
        if (i+j < 0)  break;
        if (iLow(ccy,tf,i+j) < iLow(ccy,tf,i) + ClearancePips*pnt)   validL = false;
      }
      if (VisCompletionRequired && i <= VL2)   validL = false;
      if (validL)  {
        xCount[elem] += 1;
        xLastBar[elem] = i;
        if(xStartBar[elem] < 0)   xStartBar[elem] = i;
        h_elem = MathMax(h_elem,elem);
        h_freq = MathMax(h_freq,xCount[elem]);
    } }
  }  

  if (IncludeNextBandAbove)  {
    for (i=0; i<h_elem; i++)   {
      if (xCount[i] < 1)   continue;
      xCount[i] += xCount[i+1];
      if(xStartBar[i] < 0)   xStartBar[i] = xStartBar[i+1];
      h_freq = MathMax(h_freq,xCount[i]);
  } }

  int timinc = Time[1] - Time[2];

  for (i=0; i<=h_elem; i++)   {
    if (xCount[i] < CL[0])   continue;
    double prc    = BasePrice + i * BandwidthPips/mult;
    double aveprc = (2*prc+BandwidthPips/mult-Point)/2;
    if (PlotProximityPips > 0 && MathAbs(Close[HistoricalShift] - prc) > PlotProximityPips*pnt)    continue;
    if (!ShowHistogramOnly)  {
      string objname = IndiName + "-" + i;
      int startbar = iBarShift(ccy,Period(),iTime(ccy,tf,xStartBar[i]));
      int endbar = 0;
      if (LOBL1 != 0)  {
        if (LOBL2 == "R")
          endbar = MathMax(0,iBarShift(ccy,Period(),iTime(ccy,LOBL3,MathMax(0,xLastBar[i]-LOBL1))));
        else
          endbar = MathMax(0,iBarShift(ccy,Period(),iTime(ccy,LOBL3,MathMax(0,xStartBar[i]-LOBL1))));
      }  
      if (LineWidth == 0)
        ObjectCreate(objname,OBJ_RECTANGLE,0,Time[startbar],prc,Time[endbar],prc+BandwidthPips/mult-Point);
      else {
        ObjectCreate(objname,OBJ_TREND,0,Time[startbar],aveprc,Time[endbar],aveprc);
        ObjectSet(objname,OBJPROP_RAY,false);
        ObjectSet(objname,OBJPROP_WIDTH,MathAbs(LineWidth));
        if (LineWidth > 0)  
          ObjectSet(objname,OBJPROP_RAY,false);
        else
          ObjectSet(objname,OBJPROP_RAY,true);
        if (Background)   ObjectSet(objname,OBJPROP_BACK,true);
      }  
      ObjectSet(objname,OBJPROP_TIMEFRAMES,DispTF);
      if (DescriptionMask > "")   {
        if (StringSubstr(DescriptionMask,0,1) == "*")   {
          string dmask = StringSubstr(DescriptionMask,1);
          double price = ObjectGet(objname,OBJPROP_PRICE1);
          string objtext = NumberToStr(price,dmask);
          ObjectSetText(objname,objtext,12,"Arial",Gray);
        } else {
          int objnum = MathAbs(StrToNumber(IndiName));
          objtext = NumberToStr(objnum,DescriptionMask);
          ObjectSetText(objname,objtext,12,"Arial",Gray);
      } }
      if (!Background)   ObjectSet(objname,OBJPROP_BACK,0);
      for (j=0; j<ccCL; j++)   {
        if (CL[j] < 1)  continue;
        if (xCount[i] >= CL[j])    ObjectSet(objname,OBJPROP_COLOR,CC[j]);
    } }
    if (HistogramSize > 0)   {   
      objname = IndiName + "-H-" + i;
      datetime tim1 = Time[0] + timinc;
      datetime tim2 = Time[0] + MathRound(xCount[i] * HistogramSize / h_freq + 1) * timinc;
      if (LineWidth == 0)
        ObjectCreate(objname,OBJ_RECTANGLE,0,tim1,prc,tim2,prc+BandwidthPips/mult-Point);
      else {
        ObjectCreate(objname,OBJ_TREND,0,tim1,aveprc,tim2,aveprc);
        ObjectSet(objname,OBJPROP_BACK,false);
        ObjectSet(objname,OBJPROP_WIDTH,MathAbs(LineWidth));
        ObjectSet(objname,OBJPROP_RAY,false);
      }  
      ObjectSet(objname,OBJPROP_TIMEFRAMES,DispTF);
      if (!Background)   ObjectSet(objname,OBJPROP_BACK,0);
      for (j=0; j<ccCL; j++)   {
        if (CL[j] < 1)  continue;
        if (xCount[i] >= CL[j])    ObjectSet(objname,OBJPROP_COLOR,CC[j]);
      }
      if (HistogramFontSize > 0)  {
        objname = IndiName + "-HT-" + i;
        tim2 = Time[0] + MathRound(xCount[i] * HistogramSize / h_freq / 2 + 1) * timinc;
        objtext = NumberToStr(xCount[i],"TL5");
        if (HistogramPriceMask > "")
          objtext = objtext + " : " + NumberToStr(prc,HistogramPriceMask);
        ObjectCreate(objname,OBJ_TEXT,0,tim2,prc+BandwidthPips/mult-Point);
        ObjectSet(objname,OBJPROP_TIMEFRAMES,DispTF);
        ObjectSetText(objname,objtext,HistogramFontSize,HistogramFont,HistogramFontColor);
    } }
  }

  if (OutputFile > "")  {
    string of_name = OutputFile;
    of_name = StringReplace(of_name,"[sym]",ReduceCcy(Symbol()));
    of_name = StringReplace(of_name,"[tf]",TFToStr(Period()));
    int handle = FileOpen(of_name,FILE_CSV|FILE_WRITE,';');
    if (handle==0)  Comment("File " + of_name + " not found.");

    string str = "Pair  ,TF,Level,   Price,Count, Start,        Date/Time,   End,        Date/Time";
    FileWrite(handle,str);
    for (i=0; i<=h_elem; i++)   {
      if (xCount[i] >= OutputMinFrequency)   {
        prc = BasePrice + i * BandwidthPips/mult;
        datetime start = iTime(ccy,tf,xStartBar[i]);
        datetime last  = iTime(ccy,tf,xLastBar[i]);
        str = ccy + "," + TFToStr(tf) + "," + NumberToStr(i,"Z5") + "," + NumberToStr(prc,mask) + "," + NumberToStr(xCount[i],"5");
        str = str + "," + NumberToStr(xStartBar[i],"-5") + "," + DateToStr(start,"B Y.M.D H:I");
        str = str + "," + NumberToStr(xLastBar[i],"-5") + "," + DateToStr(last,"B Y.M.D H:I");
        FileWrite(handle,str);
    } }
    FileClose(handle);
  }

  return(0);
}


//+------------------------------------------------------------------+
int CheckPresets()
//+------------------------------------------------------------------+
{
//---------------------------------------------------------------------------------------------------------------
//    Enter the file name in here
//---------------------------------------------------------------------------------------------------------------
  ParameterFile = StringUpper(ParameterFile);
  string FileName = "Presets---Recent SR.TXT";
  if (ParameterFile > "")  FileName = "Presets---Recent SR." + ParameterFile;
//---------------------------------------------------------------------------------------------------------------
  int handle = FileOpen(FileName, FILE_CSV|FILE_READ,';');
  if (handle > 0)  {
    while(!FileIsEnding(handle))  {
      string text  = FileReadString(handle);
      int t0 = StringFind(text,"//",0);
      if (t0 == 0)       text = "";    
      else if (t0 > 0)   text = StringSubstr(text,0,t0);
      string temp  = "";
      int    quote = 0;
      for(int i=0; i<StringLen(text); i++)   {
        string char = StringSubstr(text,i,1);
        if (char == "\x22")    quote = 1 - quote;  
        else if (quote == 1)    temp  = temp + char;
        else if (char != " " && char != "_") temp  = temp + StringLower(char);  
      }
      if (StringLen(temp) > 0) {
        int equal = StringFind(temp,"=",0);
        int semic = StringFind(temp,";",0);
        string pname = "";
        pname   = StringSubstr(temp,0,equal);
        string pvalue = StringSubstr(temp,equal+1,semic-equal+1);
        if (pvalue != "*")  {
//---------------------------------------------------------------------------------------------------------------
//    Parameter assignment statements go in here
//---------------------------------------------------------------------------------------------------------------
          if (pname == "timeframe")                TimeFrame                = pvalue;                     else
          if (pname == "lookbackcandles")          LookbackCandles          = StrToInteger(pvalue);       else
          if (pname == "startdatetime")            StartDateTime            = StrToTime(pvalue);          else
          if (pname == "includecurrentcandle")     IncludeCurrentCandle     = StrToBool(pvalue);          else
          if (pname == "bandwidthpips")            BandwidthPips            = StrToDouble(pvalue);        else
          if (pname == "frequencylevels")          FrequencyLevels          = pvalue;                     else
          if (pname == "frequencycolors")          FrequencyColors          = pvalue;                     else
          if (pname == "includenextbandabove")     IncludeNextBandAbove     = StrToBool(pvalue);          else
          if (pname == "visibilitylevel")          VisibilityLevel          = pvalue;                     else
          if (pname == "clearancepips")            ClearancePips            = StrToDouble(pvalue);        else
          if (pname == "viscompletionrequired")    VisCompletionRequired    = StrToBool(pvalue);          else
          if (pname == "candlehighsvalid")         CandleHighsValid         = StrToBool(pvalue);          else
          if (pname == "candlelowsvalid")          CandleLowsValid          = StrToBool(pvalue);          else
          if (pname == "candleclosesvalid")        CandleClosesValid        = StrToBool(pvalue);          else
          if (pname == "allcandlepointsvalid")     AllCandlePointsValid     = StrToBool(pvalue);          else
//          if (pname == "mininterveningcandles")    MinInterveningCandles    = StrToInteger(pvalue);       else
//          if (pname == "maxinterveningcandles")    MaxInterveningCandles    = StrToInteger(pvalue);       else
          if (pname == "linewidth")                LineWidth                = StrToInteger(pvalue);       else
          if (pname == "background")               Background               = StrToBool(pvalue);          else
          if (pname == "lineorbandlength")         LineOrBandLength         = pvalue;                     else
          if (pname == "histogramsize")            HistogramSize            = StrToInteger(pvalue);       else
          if (pname == "histogramfontsize")        HistogramFontSize        = StrToInteger(pvalue);       else
          if (pname == "histogramfont")            HistogramFont            = pvalue;                     else
          if (pname == "histogramfontcolor")       HistogramFontColor       = StrToColor(pvalue);         else
          if (pname == "histogrampricemask")       HistogramPriceMask       = pvalue;                     else
          if (pname == "showhistogramonly")        ShowHistogramOnly        = StrToBool(pvalue);          else
          if (pname == "showontimeframes")         ShowOnTimeFrames         = pvalue;                     else
          if (pname == "descriptionmask")          DescriptionMask          = pvalue;                     else
          if (pname == "plotproximitypips")        PlotProximityPips        = StrToDouble(pvalue);        else
          if (pname == "historicalshift")          HistoricalShift          = StrToInteger(pvalue);       else
          if (pname == "refresheveryxmins")        RefreshEveryXMins        = pvalue;                     else
          if (pname == "outputfile")               OutputFile               = pvalue;                     else
          if (pname == "outputminfrequency")       OutputMinFrequency       = StrToInteger(pvalue);       else
          if (pname == "deletelinesondeinit")      DeleteLinesOnDeinit      = StrToBool(pvalue);
//          Debug("pname  = " + pname);
//          Debug("pvalue = " + pvalue);
//---------------------------------------------------------------------------------------------------------------
        }
      }  
      temp = FileReadString(handle);
    }
    FileClose(handle);
  }  

  tf = StrToTF(TimeFrame);  

  ccCL = StrToIntegerArray(FrequencyLevels,CL,",");
  ccCC = StrToColorArray(FrequencyColors,CC,",");

  VL[0] = ""; VL[1] = "";
  StrToStringArray(VisibilityLevel,VL,",");
  VL1 = StrToInteger(VL[0]);
  if (VL[1] == "")
    VL2 = VL1;
  else
    VL2 = StrToInteger(VL[1]);

  StrToStringArray(LineOrBandLength,LOBL,",");
  LOBL1 = StrToNumber(LOBL[0]);
  LOBL2 = StringTrim(StringUpper(LOBL[1]));
  LOBL3 = StrToTF(LOBL[2]);

  int checksum = 0;
  string str = TimeFrame + LookbackCandles + DateToStr(StartDateTime,"YMDHI") + IncludeCurrentCandle + NumberToStr(BandwidthPips,"Z4.1");
  str = str + FrequencyLevels + FrequencyColors + VisibilityLevel + NumberToStr(ClearancePips,"Z4.1") + CandleHighsValid + CandleLowsValid;
  str = str + CandleClosesValid + AllCandlePointsValid + HistogramSize + ShowHistogramOnly + NumberToStr(LineWidth,"-1") + UniqueID;
//  str = str + CandleClosesValid + AllCandlePointsValid + MinInterveningCandles + MaxInterveningCandles + HistogramSize + ShowHistogramOnly;
  for (i=0; i<StringLen(str); i++)  
    checksum += i * StringGetChar(str,i);
  IndiName = "RecentSR-" + NumberToStr(checksum,"Z7");
  IndicatorShortName(IndiName);
  
  RefreshFreq = StrToTF(RefreshEveryXMins);

  return(0);
}

//+------------------------------------------------------------------+
#include <hanover --- extensible functions.mqh>

